@extends('admin.app')

@section('content')

    <h3 class="font-semibold text-[26px] leading-10 capitalize text-primary">{{ greeting() }}</h3>
    <h4 class="font-medium text-[22px] leading-[34px] capitalize">{{ ucwords(auth()->user()->name) }}</h4>
    </div>
    <div class="row">
        <div class="col-12">
            <h4 class="font-semibold text-[22px] leading-[34px] mb-4 capitalize mt-5">{{ __('dashboard.overview') }}</h4>
            @if (auth()->user()->myrole == App\Enums\UserRole::ADMIN)
                <div class="row mb-9">
                    <div class="col-12 sm:col-6 xl:col-3">
                        <div class="p-4 rounded-lg flex items-center gap-4 card-statistic-1">
                            <div class="w-12 h-12 rounded-full flex items-center justify-center bg-white">

                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M20.2102 7.82L12.5102 12.28C12.2002 12.46 11.8102 12.46 11.4902 12.28L3.79021 7.82C3.24021 7.5 3.10021 6.75 3.52021 6.28C3.81021 5.95 4.14021 5.68 4.49021 5.49L9.91021 2.49C11.0702 1.84 12.9502 1.84 14.1102 2.49L19.5302 5.49C19.8802 5.68 20.2102 5.96 20.5002 6.28C20.9002 6.75 20.7602 7.5 20.2102 7.82Z" fill="#EE1D48"/>
                                    <path d="M11.4305 14.14V20.96C11.4305 21.72 10.6605 22.22 9.98047 21.89C7.92047 20.88 4.45047 18.99 4.45047 18.99C3.23047 18.3 2.23047 16.56 2.23047 15.13V9.97C2.23047 9.18 3.06047 8.68 3.74047 9.07L10.9305 13.24C11.2305 13.43 11.4305 13.77 11.4305 14.14Z" fill="#EE1D48"/>
                                    <path d="M12.5703 14.14V20.96C12.5703 21.72 13.3403 22.22 14.0203 21.89C16.0803 20.88 19.5503 18.99 19.5503 18.99C20.7703 18.3 21.7703 16.56 21.7703 15.13V9.97C21.7703 9.18 20.9403 8.68 20.2603 9.07L13.0703 13.24C12.7703 13.43 12.5703 13.77 12.5703 14.14Z" fill="#EE1D48"/>
                                </svg>
                            </div>
                            <div>
                                <h3 class="font-bold text-white">{{ __('dashboard.total_orders') }}</h3>
                                <h4 class="font-bold text-white text-2xl leading[34px]">{{ $totalOrders }}</h4>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 sm:col-6 xl:col-3">
                        <div class="p-4 rounded-lg flex items-center gap-4 card-statistic-2">
                            <div class="w-12 h-12 rounded-full flex items-center justify-center bg-white">

                                <svg width="24" height="24" viewBox="0 0 24 24" fill="#6e7191" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9 2C6.38 2 4.25 4.13 4.25 6.75C4.25 9.32 6.26 11.4 8.88 11.49C8.96 11.48 9.04 11.48 9.1 11.49C9.12 11.49 9.13 11.49 9.15 11.49C9.16 11.49 9.16 11.49 9.17 11.49C11.73 11.4 13.74 9.32 13.75 6.75C13.75 4.13 11.62 2 9 2Z" fill="#3abaf4" />
                                    <path d="M14.08 14.15C11.29 12.29 6.73996 12.29 3.92996 14.15C2.65996 15 1.95996 16.15 1.95996 17.38C1.95996 18.61 2.65996 19.75 3.91996 20.59C5.31996 21.53 7.15996 22 8.99996 22C10.84 22 12.68 21.53 14.08 20.59C15.34 19.74 16.04 18.6 16.04 17.36C16.03 16.13 15.34 14.99 14.08 14.15Z" fill="#3abaf4" />
                                    <path d="M19.9904 7.33998C20.1504 9.27998 18.7704 10.98 16.8604 11.21C16.8504 11.21 16.8504 11.21 16.8404 11.21H16.8104C16.7504 11.21 16.6904 11.21 16.6404 11.23C15.6704 11.28 14.7804 10.97 14.1104 10.4C15.1404 9.47998 15.7304 8.09998 15.6104 6.59998C15.5404 5.78998 15.2604 5.04998 14.8404 4.41998C15.2204 4.22998 15.6604 4.10998 16.1104 4.06998C18.0704 3.89998 19.8204 5.35998 19.9904 7.33998Z" fill="#3abaf4" />
                                    <path d="M21.9902 16.59C21.9102 17.56 21.2902 18.4 20.2502 18.97C19.2502 19.52 17.9902 19.78 16.7402 19.75C17.4602 19.1 17.8802 18.29 17.9602 17.43C18.0602 16.19 17.4702 15 16.2902 14.05C15.6202 13.52 14.8402 13.1 13.9902 12.79C16.2002 12.15 18.9802 12.58 20.6902 13.96C21.6102 14.7 22.0802 15.63 21.9902 16.59Z" fill="#3abaf4" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="font-bold text-white">{{ __('dashboard.total_customers') }}</h3>
                                <h4 class="font-bold text-white text-2xl leading[34px]">{{ $totalUsers }}</h4>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 sm:col-6 xl:col-3">
                        <div class="p-4 rounded-lg flex items-center gap-4 card-statistic-3">
                            <div class="w-12 h-12 rounded-full flex items-center justify-center bg-white">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="#ffa426" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M3.4215 5.0235C3.2869 5.02693 3.15298 5.0032 3.02775 4.95373C2.90253 4.90425 2.78856 4.83004 2.69265 4.73554C2.59674 4.64103 2.52087 4.52816 2.46955 4.40368C2.41824 4.27919 2.39255 4.14564 2.394 4.011C2.394 3.4365 2.841 3 3.4215 3H20.5395C21.123 3 21.567 3.4395 21.567 4.011C21.5685 4.14564 21.5428 4.27919 21.4914 4.40368C21.4401 4.52816 21.3643 4.64103 21.2684 4.73554C21.1724 4.83004 21.0585 4.90425 20.9332 4.95373C20.808 5.0032 20.6741 5.02693 20.5395 5.0235H3.42H3.4215ZM17.9535 14.2785C18.432 15.4275 19.6035 16.2435 20.964 16.2435C21.2865 16.2435 21.5955 16.197 21.8895 16.1115V22.6335C21.8895 23.2395 21.2055 23.9805 20.5905 23.9805H3.3705C2.7555 23.9805 2.0715 23.2395 2.0715 22.6335V16.11C2.3655 16.1955 2.6745 16.242 2.997 16.242C4.362 16.242 5.529 15.429 6.0075 14.277C6.25405 14.8624 6.66867 15.3616 7.19893 15.7114C7.7292 16.0611 8.35128 16.2458 8.9865 16.242C10.3485 16.242 11.517 15.429 11.997 14.277C12.2434 14.8622 12.6578 15.3612 13.1878 15.711C13.7178 16.0607 14.3395 16.2455 14.9745 16.242C15.6098 16.246 16.2319 16.0614 16.7622 15.7116C17.2925 15.3618 17.7071 14.8626 17.9535 14.277V14.2785ZM21.8385 5.922L23.9685 11.211C23.9685 12.8295 22.5975 14.1075 20.9535 14.1075C19.2735 14.1075 17.94 12.795 17.94 11.2125C17.94 12.8295 16.605 14.1075 14.9625 14.1075C13.3185 14.1075 11.9835 12.795 11.9835 11.2125C11.9835 12.8295 10.614 14.1075 8.97 14.1075C7.326 14.1075 5.9925 12.795 5.9925 11.2125C5.9925 12.8295 4.623 14.1075 2.9775 14.1075C1.335 14.1075 0 12.795 0 11.2125L2.052 5.922H21.837H21.8385Z"/>
                                </svg>
                            </div>
                            <div>
                                <h3 class="font-bold text-white">{{ __('dashboard.total_restaurants') }}</h3>
                                <h4 class="font-bold text-white text-2xl leading[34px]">{{ $totalRestaurants }}</h4>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 sm:col-6 xl:col-3">
                        <div class="p-4 rounded-lg flex items-center gap-4 card-statistic-4">
                            <div class="w-12 h-12 rounded-full flex items-center justify-center bg-white">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M12.75 15.92H13.4C14.05 15.92 14.59 15.34 14.59 14.64C14.59 13.77 14.28 13.6 13.77 13.42L12.76 13.07V15.92H12.75Z" fill="#47c363" />
                                    <path d="M11.9701 1.89998C6.45007 1.91998 1.98007 6.40998 2.00007 11.93C2.02007 17.45 6.51007 21.92 12.0301 21.9C17.5501 21.88 22.0201 17.39 22.0001 11.87C21.9801 6.34998 17.4901 1.88998 11.9701 1.89998ZM14.2601 12C15.0401 12.27 16.0901 12.85 16.0901 14.64C16.0901 16.18 14.8801 17.42 13.4001 17.42H12.7501V18C12.7501 18.41 12.4101 18.75 12.0001 18.75C11.5901 18.75 11.2501 18.41 11.2501 18V17.42H10.8901C9.25007 17.42 7.92007 16.04 7.92007 14.34C7.92007 13.93 8.26007 13.59 8.67007 13.59C9.08007 13.59 9.42007 13.93 9.42007 14.34C9.42007 15.21 10.0801 15.92 10.8901 15.92H11.2501V12.54L9.74007 12C8.96007 11.73 7.91007 11.15 7.91007 9.35998C7.91007 7.81998 9.12007 6.57998 10.6001 6.57998H11.2501V5.99998C11.2501 5.58998 11.5901 5.24998 12.0001 5.24998C12.4101 5.24998 12.7501 5.58998 12.7501 5.99998V6.57998H13.1101C14.7501 6.57998 16.0801 7.95998 16.0801 9.65998C16.0801 10.07 15.7401 10.41 15.3301 10.41C14.9201 10.41 14.5801 10.07 14.5801 9.65998C14.5801 8.78998 13.9201 8.07998 13.1101 8.07998H12.7501V11.46L14.2601 12Z" fill="#47c363" />
                                    <path d="M9.41992 9.37002C9.41992 10.24 9.72992 10.41 10.2399 10.59L11.2499 10.94V8.08002H10.5999C9.94992 8.08002 9.41992 8.66002 9.41992 9.37002Z" fill="#47c363" />
                                </svg>
                            </div>
                            <div>
                                <h3 class="font-bold text-white">{{ __('dashboard.total_income') }}</h3>
                                <h4 class="font-bold text-white text-2xl leading[34px]">
                                    {{ currencyFormat(number_format($totalIncome, 2)) }}</h4>
                            </div>
                        </div>
                    </div>
                </div>
            @elseif (auth()->user()->myrole == App\Enums\UserRole::RESTAURANTOWNER)
                <div class="row mb-9">
                    <div class="col-12 sm:col-6 xl:col-3">
                        <div class="card card-statistic-1">
                            <div class="card-icon bg-warning">
                                <svg width="24" height="24" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 580 512">
                                    <path d="M290.8 48.6l78.4 29.7L288 109.5 206.8 78.3l78.4-29.7c1.8-.7 3.8-.7 5.7 0zM136 92.5l0 112.2c-1.3 .4-2.6 .8-3.9 1.3l-96 36.4C14.4 250.6 0 271.5 0 294.7L0 413.9c0 22.2 13.1 42.3 33.5 51.3l96 42.2c14.4 6.3 30.7 6.3 45.1 0L288 457.5l113.5 49.9c14.4 6.3 30.7 6.3 45.1 0l96-42.2c20.3-8.9 33.5-29.1 33.5-51.3l0-119.1c0-23.3-14.4-44.1-36.1-52.4l-96-36.4c-1.3-.5-2.6-.9-3.9-1.3l0-112.2c0-23.3-14.4-44.1-36.1-52.4l-96-36.4c-12.8-4.8-26.9-4.8-39.7 0l-96 36.4C150.4 48.4 136 69.3 136 92.5zM392 210.6l-82.4 31.2 0-89.2L392 121l0 89.6zM154.8 250.9l78.4 29.7L152 311.7 70.8 280.6l78.4-29.7c1.8-.7 3.8-.7 5.7 0zm18.8 204.4l0-100.5L256 323.2l0 95.9-82.4 36.2zM421.2 250.9c1.8-.7 3.8-.7 5.7 0l78.4 29.7L424 311.7l-81.2-31.1 78.4-29.7zM523.2 421.2l-77.6 34.1 0-100.5L528 323.2l0 90.7c0 3.2-1.9 6-4.8 7.3z" fill="#EE1D48"/>
                                </svg>
                            </div>
                            <div class="card-wrap">
                                <div class="card-header">
                                    <h4 class="font-bold">{{ __('dashboard.pending_orders') }}</h4>
                                </div>
                                <div class="card-body font-bold text-white text-2xl leading[34px]">
                                    {{ $ownerNotificationOrders }}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 sm:col-6 xl:col-3">
                        <div class="card card-statistic-2">
                            <div class="card-icon bg-primary">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M20.2102 7.82L12.5102 12.28C12.2002 12.46 11.8102 12.46 11.4902 12.28L3.79021 7.82C3.24021 7.5 3.10021 6.75 3.52021 6.28C3.81021 5.95 4.14021 5.68 4.49021 5.49L9.91021 2.49C11.0702 1.84 12.9502 1.84 14.1102 2.49L19.5302 5.49C19.8802 5.68 20.2102 5.96 20.5002 6.28C20.9002 6.75 20.7602 7.5 20.2102 7.82Z" fill="#3abaf4"/>
                                    <path d="M11.4305 14.14V20.96C11.4305 21.72 10.6605 22.22 9.98047 21.89C7.92047 20.88 4.45047 18.99 4.45047 18.99C3.23047 18.3 2.23047 16.56 2.23047 15.13V9.97C2.23047 9.18 3.06047 8.68 3.74047 9.07L10.9305 13.24C11.2305 13.43 11.4305 13.77 11.4305 14.14Z" fill="#3abaf4"/>
                                    <path d="M12.5703 14.14V20.96C12.5703 21.72 13.3403 22.22 14.0203 21.89C16.0803 20.88 19.5503 18.99 19.5503 18.99C20.7703 18.3 21.7703 16.56 21.7703 15.13V9.97C21.7703 9.18 20.9403 8.68 20.2603 9.07L13.0703 13.24C12.7703 13.43 12.5703 13.77 12.5703 14.14Z" fill="#3abaf4"/>
                                </svg>
                            </div>
                            <div class="card-wrap">
                                <div class="card-header">
                                    <h4 class="font-bold">{{ __('dashboard.total_orders') }}</h4>
                                </div>
                                <div class="card-body font-bold text-white text-2xl leading[34px]">
                                    {{ $ownerTotalOrders }}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 sm:col-6 xl:col-3">
                        <div class="card card-statistic-3">
                            <div class="card-icon bg-danger">
                                <svg width="24" height="24" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
                                    <path d="M64 256l0-96 160 0 0 96L64 256zm0 64l160 0 0 96L64 416l0-96zm224 96l0-96 160 0 0 96-160 0zM448 256l-160 0 0-96 160 0 0 96zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32z"/>
                                </svg>
                            </div>
                            <div class="card-wrap">
                                <div class="card-header">
                                    <h4 class="font-bold">{{ __('dashboard.total_booking') }}</h4>
                                </div>
                                <div class="card-body font-bold text-white text-2xl leading[34px]">
                                    {{ $ownerTotalReservations }}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 sm:col-6 xl:col-3">
                        <div class="card card-statistic-4">
                            <div class="card-icon bg-success">
                                <i class="fas fa-money-bill"></i>
                            </div>
                            <div class="card-wrap">
                                <div class="card-header">
                                    <h4 class="font-bold">{{ __('dashboard.available_credit') }}</h4>
                                </div>
                                <div class="card-body font-bold text-white text-2xl leading[34px]">
                                    {{ $userCredit }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @elseif(auth()->user()->myrole == App\Enums\UserRole::DELIVERYBOY)
                <div class="row mb-9">
                    <div class="col-12 sm:col-6 xl:col-4">
                        <div class="card card-statistic-2">
                            <div class="card-icon bg-primary">
                                <i class="fas fa-cubes"></i>
                            </div>
                            <div class="card-wrap">
                                <div class="card-header">
                                    <h4 class="font-bold">{{ __('dashboard.total_notification_order') }}</h4>
                                </div>
                                <div class="card-body font-bold text-white text-2xl leading[34px]">
                                    {{ $notificationOrders }}
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-12 sm:col-6 xl:col-4">
                        <div class="card card-statistic-3">
                            <div class="card-icon bg-danger">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M20.2102 7.82L12.5102 12.28C12.2002 12.46 11.8102 12.46 11.4902 12.28L3.79021 7.82C3.24021 7.5 3.10021 6.75 3.52021 6.28C3.81021 5.95 4.14021 5.68 4.49021 5.49L9.91021 2.49C11.0702 1.84 12.9502 1.84 14.1102 2.49L19.5302 5.49C19.8802 5.68 20.2102 5.96 20.5002 6.28C20.9002 6.75 20.7602 7.5 20.2102 7.82Z" fill="#ffa426"/>
                                    <path d="M11.4305 14.14V20.96C11.4305 21.72 10.6605 22.22 9.98047 21.89C7.92047 20.88 4.45047 18.99 4.45047 18.99C3.23047 18.3 2.23047 16.56 2.23047 15.13V9.97C2.23047 9.18 3.06047 8.68 3.74047 9.07L10.9305 13.24C11.2305 13.43 11.4305 13.77 11.4305 14.14Z" fill="#ffa426"/>
                                    <path d="M12.5703 14.14V20.96C12.5703 21.72 13.3403 22.22 14.0203 21.89C16.0803 20.88 19.5503 18.99 19.5503 18.99C20.7703 18.3 21.7703 16.56 21.7703 15.13V9.97C21.7703 9.18 20.9403 8.68 20.2603 9.07L13.0703 13.24C12.7703 13.43 12.5703 13.77 12.5703 14.14Z" fill="#ffa426"/>
                                </svg>
                            </div>
                            <div class="card-wrap">
                                <div class="card-header">
                                    <h4 class="font-bold">{{ __('dashboard.total_orders') }}</h4>
                                </div>
                                <div class="card-body font-bold text-white text-2xl leading[34px]">
                                    {{ $totalDaliveryOrders }}
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-12 sm:col-6 xl:col-4">
                        <div class="card card-statistic-4">
                            <div class="card-icon bg-success">
                                <i class="fas fa-money-bill"></i>
                            </div>
                            <div class="card-wrap">
                                <div class="card-header">
                                    <h4 class="font-bold">{{ __('dashboard.available_credit') }}</h4>
                                </div>
                                <div class="card-body font-bold text-white text-2xl leading[34px]">
                                    {{ $userCredit }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            <div>
                <div class="row">
                    @if (auth()->user()->myrole == App\Enums\UserRole::ADMIN || auth()->user()->myrole == App\Enums\UserRole::RESTAURANTOWNER)
                        <div class="col-12 pb-0">
                            <div class="flex items-center justify-between mb-4">
                                <h4 class="font-semibold text-[22px] leading-[34px] mb-3 capitalize">
                                    {{ __('dashboard.order_statistics') }}</h4>
                                <div id="orderDateRange"
                                    class="min-w-[150px] cursor-pointer py-2 px-4 rounded-lg flex items-center gap-3 border border-primary bg-primary-light">
                                    <span class="capitalize text-base text-primary"></span>
                                    <svg class="fill-primary" width="16" height="16" viewBox="0 0 16 16"
                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M11.9465 5.45312H7.79316H4.05317C3.41317 5.45312 3.09317 6.22646 3.5465 6.67979L6.99983 10.1331C7.55317 10.6865 8.45317 10.6865 9.0065 10.1331L10.3198 8.81979L12.4598 6.67979C12.9065 6.22646 12.5865 5.45312 11.9465 5.45312Z">
                                        </path>
                                    </svg>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 sm:col-6 md:col-4 lg:col-6 xl:col-3">
                            <div class="flex items-center gap-4 p-4 rounded-lg shadow-xs bg-white">
                                <div class="w-12 h-12 rounded-full flex items-center justify-center bg-[#FFE6F0]">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M20.2102 7.82L12.5102 12.28C12.2002 12.46 11.8102 12.46 11.4902 12.28L3.79021 7.82C3.24021 7.5 3.10021 6.75 3.52021 6.28C3.81021 5.95 4.14021 5.68 4.49021 5.49L9.91021 2.49C11.0702 1.84 12.9502 1.84 14.1102 2.49L19.5302 5.49C19.8802 5.68 20.2102 5.96 20.5002 6.28C20.9002 6.75 20.7602 7.5 20.2102 7.82Z" fill="#8262FE"/>
                                        <path d="M11.4305 14.14V20.96C11.4305 21.72 10.6605 22.22 9.98047 21.89C7.92047 20.88 4.45047 18.99 4.45047 18.99C3.23047 18.3 2.23047 16.56 2.23047 15.13V9.97C2.23047 9.18 3.06047 8.68 3.74047 9.07L10.9305 13.24C11.2305 13.43 11.4305 13.77 11.4305 14.14Z" fill="#8262FE"/>
                                        <path d="M12.5703 14.14V20.96C12.5703 21.72 13.3403 22.22 14.0203 21.89C16.0803 20.88 19.5503 18.99 19.5503 18.99C20.7703 18.3 21.7703 16.56 21.7703 15.13V9.97C21.7703 9.18 20.9403 8.68 20.2603 9.07L13.0703 13.24C12.7703 13.43 12.5703 13.77 12.5703 14.14Z" fill="#8262FE"/>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-normal text-sm leading-6 capitalize text-paragraph">
                                        {{ __('dashboard.total_orders') }}</h3>
                                    <h4 class="font-bold text-lg leading-[34px]" id="totalOrders">
                                        {{ @$order_statistics->total ?? 0 }}</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 sm:col-6 md:col-4 lg:col-6 xl:col-3">
                            <div class="flex items-center gap-4 p-4 rounded-lg shadow-xs bg-white">
                                <div class="w-12 h-12 rounded-full flex items-center justify-center bg-[#FFF6E6]">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M17.6005 5.31003L11.9505 2.27003C11.3505 1.95003 10.6405 1.95003 10.0405 2.27003L4.40047 5.31003C3.99047 5.54003 3.73047 5.98003 3.73047 6.46003C3.73047 6.95003 3.98047 7.39003 4.40047 7.61003L10.0505 10.65C10.3505 10.81 10.6805 10.89 11.0005 10.89C11.3205 10.89 11.6605 10.81 11.9505 10.65L17.6005 7.61003C18.0105 7.39003 18.2705 6.95003 18.2705 6.46003C18.2705 5.98003 18.0105 5.54003 17.6005 5.31003Z"
                                            fill="#F6A609"></path>
                                        <path
                                            d="M9.12 11.71L3.87 9.09003C3.46 8.88003 3 8.91003 2.61 9.14003C2.23 9.38003 2 9.79003 2 10.24V15.2C2 16.06 2.48 16.83 3.25 17.22L8.5 19.84C8.68 19.93 8.88 19.98 9.08 19.98C9.31 19.98 9.55 19.91 9.76 19.79C10.14 19.55 10.37 19.14 10.37 18.69V13.73C10.36 12.87 9.88 12.1 9.12 11.71Z"
                                            fill="#F6A609"></path>
                                        <path
                                            d="M19.9996 10.24V12.7C19.5196 12.56 19.0096 12.5 18.4996 12.5C17.1396 12.5 15.8096 12.97 14.7596 13.81C13.3196 14.94 12.4996 16.65 12.4996 18.5C12.4996 18.99 12.5596 19.48 12.6896 19.95C12.5396 19.93 12.3896 19.87 12.2496 19.78C11.8696 19.55 11.6396 19.14 11.6396 18.69V13.73C11.6396 12.87 12.1196 12.1 12.8796 11.71L18.1296 9.09003C18.5396 8.88003 18.9996 8.91003 19.3896 9.14003C19.7696 9.38003 19.9996 9.79003 19.9996 10.24Z"
                                            fill="#F6A609"></path>
                                        <path
                                            d="M21.98 15.65C21.16 14.64 19.91 14 18.5 14C17.44 14 16.46 14.37 15.69 14.99C14.65 15.81 14 17.08 14 18.5C14 19.91 14.64 21.16 15.65 21.98C16.42 22.62 17.42 23 18.5 23C19.64 23 20.67 22.57 21.47 21.88C22.4 21.05 23 19.85 23 18.5C23 17.42 22.62 16.42 21.98 15.65ZM19.53 18.78C19.53 19.04 19.39 19.29 19.17 19.42L17.76 20.26C17.64 20.33 17.51 20.37 17.37 20.37C17.12 20.37 16.87 20.24 16.73 20.01C16.52 19.65 16.63 19.19 16.99 18.98L18.03 18.36V17.1C18.03 16.69 18.37 16.35 18.78 16.35C19.19 16.35 19.53 16.69 19.53 17.1V18.78Z"
                                            fill="#F6A609"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-normal text-sm leading-6 capitalize text-paragraph">
                                        {{ __('dashboard.pending') }}</h3>
                                    <h4 class="font-bold text-lg leading-[34px]" id="pending">
                                        {{ @$order_statistics->pending ?? 0 }}</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 sm:col-6 md:col-4 lg:col-6 xl:col-3">
                            <div class="flex items-center gap-4 p-4 rounded-lg shadow-xs bg-white">
                                <div class="w-12 h-12 rounded-full flex items-center justify-center bg-[#E7FFF0]">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M21.9697 18V19C21.9697 20.65 21.9697 22 18.9697 22H4.96973C1.96973 22 1.96973 20.65 1.96973 19V18C1.96973 17.45 2.41973 17 2.96973 17H20.9697C21.5197 17 21.9697 17.45 21.9697 18Z"
                                            fill="#2AC769"></path>
                                        <path
                                            d="M14.4095 5.18002C14.4595 4.98002 14.4895 4.79002 14.4995 4.58002C14.5295 3.42002 13.8195 2.40002 12.6995 2.10002C11.0195 1.64002 9.49953 2.90002 9.49953 4.50002C9.49953 4.74002 9.52953 4.96002 9.58953 5.18002C5.97953 5.95002 3.26953 9.16002 3.26953 13V14.5C3.26953 15.05 3.71953 15.5 4.26953 15.5H19.7195C20.2695 15.5 20.7195 15.05 20.7195 14.5V13C20.7195 9.16002 18.0195 5.96002 14.4095 5.18002ZM14.9995 11.75H8.99953C8.58953 11.75 8.24953 11.41 8.24953 11C8.24953 10.59 8.58953 10.25 8.99953 10.25H14.9995C15.4095 10.25 15.7495 10.59 15.7495 11C15.7495 11.41 15.4095 11.75 14.9995 11.75Z"
                                            fill="#2AC769"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-normal text-sm leading-6 capitalize text-paragraph">
                                        {{ __('dashboard.processing') }}</h3>
                                    <h4 class="font-bold text-lg leading-[34px]" id="processing">
                                        {{ @$order_statistics->processing ?? 0 }}</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 sm:col-6 md:col-4 lg:col-6 xl:col-3">
                            <div class="flex items-center gap-4 p-4 rounded-lg shadow-xs bg-white">
                                <div class="w-12 h-12 rounded-full flex items-center justify-center bg-[#E9F9FF]">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M21.5 15.5C21.78 15.5 22 15.72 22 16V17C22 18.66 20.66 20 19 20C19 18.35 17.65 17 16 17C14.35 17 13 18.35 13 20H11C11 18.35 9.65 17 8 17C6.35 17 5 18.35 5 20C3.34 20 2 18.66 2 17V15C2 14.45 2.45 14 3 14H12.5C13.88 14 15 12.88 15 11.5V6C15 5.45 15.45 5 16 5H16.84C17.56 5 18.22 5.39 18.58 6.01L19.22 7.13C19.31 7.29 19.19 7.5 19 7.5C17.62 7.5 16.5 8.62 16.5 10V13C16.5 14.38 17.62 15.5 19 15.5H21.5Z"
                                            fill="#008BBA"></path>
                                        <path
                                            d="M8 22C9.10457 22 10 21.1046 10 20C10 18.8954 9.10457 18 8 18C6.89543 18 6 18.8954 6 20C6 21.1046 6.89543 22 8 22Z"
                                            fill="#008BBA"></path>
                                        <path
                                            d="M16 22C17.1046 22 18 21.1046 18 20C18 18.8954 17.1046 18 16 18C14.8954 18 14 18.8954 14 20C14 21.1046 14.8954 22 16 22Z"
                                            fill="#008BBA"></path>
                                        <path
                                            d="M22 12.53V14H19C18.45 14 18 13.55 18 13V10C18 9.45 18.45 9 19 9H20.29L21.74 11.54C21.91 11.84 22 12.18 22 12.53Z"
                                            fill="#008BBA"></path>
                                        <path
                                            d="M13.08 2H5.69C3.65 2 2 3.65 2 5.69V12.07C2 12.62 2.45 13.07 3 13.07H12.15C13.17 13.07 14 12.24 14 11.22V2.92C14 2.41 13.59 2 13.08 2ZM10.07 7.07L7.98 9.09C7.83 9.23 7.64 9.3 7.46 9.3C7.27 9.3 7.08 9.23 6.94 9.09L5.93 8.13C5.63 7.84 5.62 7.36 5.91 7.06C6.19 6.76 6.67 6.76 6.97 7.04L7.46 7.51L9.03 5.99C9.33 5.7 9.8 5.71 10.09 6.01C10.38 6.31 10.37 6.78 10.07 7.07Z"
                                            fill="#008BBA"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-normal text-sm leading-6 capitalize text-paragraph">
                                        {{ __('dashboard.onTheWay') }}</h3>
                                    <h4 class="font-bold text-lg leading-[34px]" id="onTheWay">
                                        {{ @$order_statistics->onTheWay ?? 0 }}</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 sm:col-6 md:col-4 lg:col-6 xl:col-3">
                            <div class="flex items-center gap-4 p-4 rounded-lg shadow-xs bg-white">
                                <div class="w-12 h-12 rounded-full flex items-center justify-center bg-[#EBE7FF]">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M17.6005 5.31L11.9505 2.27C11.3505 1.95 10.6405 1.95 10.0405 2.27L4.40047 5.31C3.99047 5.54 3.73047 5.98 3.73047 6.46C3.73047 6.95 3.98047 7.39 4.40047 7.61L10.0505 10.65C10.3505 10.81 10.6805 10.89 11.0005 10.89C11.3205 10.89 11.6605 10.81 11.9505 10.65L17.6005 7.61C18.0105 7.39 18.2705 6.95 18.2705 6.46C18.2705 5.98 18.0105 5.54 17.6005 5.31Z"
                                            fill="#6A45FE"></path>
                                        <path
                                            d="M9.12 11.71L3.87 9.09C3.46 8.88 3 8.91 2.61 9.14C2.23 9.38 2 9.79 2 10.24V15.2C2 16.06 2.48 16.83 3.25 17.22L8.5 19.84C8.68 19.93 8.88 19.98 9.08 19.98C9.31 19.98 9.55 19.91 9.76 19.79C10.14 19.55 10.37 19.14 10.37 18.69V13.73C10.36 12.87 9.88 12.1 9.12 11.71Z"
                                            fill="#6A45FE"></path>
                                        <path
                                            d="M19.9996 10.24V12.7C19.5196 12.56 19.0096 12.5 18.4996 12.5C17.1396 12.5 15.8096 12.97 14.7596 13.81C13.3196 14.94 12.4996 16.65 12.4996 18.5C12.4996 18.99 12.5596 19.48 12.6896 19.95C12.5396 19.93 12.3896 19.87 12.2496 19.78C11.8696 19.55 11.6396 19.14 11.6396 18.69V13.73C11.6396 12.87 12.1196 12.1 12.8796 11.71L18.1296 9.09C18.5396 8.88 18.9996 8.91 19.3896 9.14C19.7696 9.38 19.9996 9.79 19.9996 10.24Z"
                                            fill="#6A45FE"></path>
                                        <path
                                            d="M21.98 15.67C21.16 14.66 19.91 14.02 18.5 14.02C17.44 14.02 16.46 14.39 15.69 15.01C14.65 15.83 14 17.1 14 18.52C14 19.36 14.24 20.16 14.65 20.84C14.92 21.29 15.26 21.68 15.66 22H15.67C16.44 22.64 17.43 23.02 18.5 23.02C19.64 23.02 20.67 22.6 21.46 21.9C21.81 21.6 22.11 21.24 22.35 20.84C22.76 20.16 23 19.36 23 18.52C23 17.44 22.62 16.44 21.98 15.67ZM20.76 17.96L18.36 20.18C18.22 20.31 18.03 20.38 17.85 20.38C17.66 20.38 17.47 20.31 17.32 20.16L16.21 19.05C15.92 18.76 15.92 18.28 16.21 17.99C16.5 17.7 16.98 17.7 17.27 17.99L17.87 18.59L19.74 16.86C20.04 16.58 20.52 16.6 20.8 16.9C21.09 17.21 21.07 17.68 20.76 17.96Z"
                                            fill="#6A45FE"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-normal text-sm leading-6 capitalize text-paragraph">
                                        {{ __('dashboard.delivered') }}</h3>
                                    <h4 class="font-bold text-lg leading-[34px]" id="delivered">
                                        {{ @$order_statistics->delivered ?? 0 }}</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 sm:col-6 md:col-4 lg:col-6 xl:col-3">
                            <div class="flex items-center gap-4 p-4 rounded-lg shadow-xs bg-white">
                                <div class="w-12 h-12 rounded-full flex items-center justify-center bg-[#FFEAEA]">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M17.6005 5.31L11.9505 2.27C11.3505 1.95 10.6405 1.95 10.0405 2.27L4.40047 5.31C3.99047 5.54 3.73047 5.98 3.73047 6.46C3.73047 6.95 3.98047 7.39 4.40047 7.61L10.0505 10.65C10.3505 10.81 10.6805 10.89 11.0005 10.89C11.3205 10.89 11.6605 10.81 11.9505 10.65L17.6005 7.61C18.0105 7.39 18.2705 6.95 18.2705 6.46C18.2705 5.98 18.0105 5.54 17.6005 5.31Z"
                                            fill="#FB4E4E"></path>
                                        <path
                                            d="M9.12 11.71L3.87 9.09C3.46 8.88 3 8.91 2.61 9.14C2.23 9.38 2 9.79 2 10.24V15.2C2 16.06 2.48 16.83 3.25 17.22L8.5 19.84C8.68 19.93 8.88 19.98 9.08 19.98C9.31 19.98 9.55 19.91 9.76 19.79C10.14 19.55 10.37 19.14 10.37 18.69V13.73C10.36 12.87 9.88 12.1 9.12 11.71Z"
                                            fill="#FB4E4E"></path>
                                        <path
                                            d="M19.9996 10.24V12.7C19.5196 12.56 19.0096 12.5 18.4996 12.5C17.1396 12.5 15.8096 12.97 14.7596 13.81C13.3196 14.94 12.4996 16.65 12.4996 18.5C12.4996 18.99 12.5596 19.48 12.6896 19.95C12.5396 19.93 12.3896 19.87 12.2496 19.78C11.8696 19.55 11.6396 19.14 11.6396 18.69V13.73C11.6396 12.87 12.1196 12.1 12.8796 11.71L18.1296 9.09C18.5396 8.88 18.9996 8.91 19.3896 9.14C19.7696 9.38 19.9996 9.79 19.9996 10.24Z"
                                            fill="#FB4E4E"></path>
                                        <path
                                            d="M21.6804 15.32C20.7904 14.43 19.6104 13.98 18.4404 14C17.3104 14.01 16.1804 14.46 15.3204 15.32C14.7204 15.91 14.3304 16.65 14.1404 17.42C14.0304 17.84 13.9904 18.27 14.0204 18.7V18.75C14.0204 18.82 14.0304 18.88 14.0404 18.96C14.0404 18.96 14.0404 18.96 14.0504 18.97V19C14.1404 19.98 14.5604 20.93 15.3204 21.68C16.4804 22.84 18.1104 23.23 19.5804 22.86C20.0204 22.75 20.4504 22.57 20.8504 22.33C21.1504 22.16 21.4304 21.94 21.6804 21.68C22.4304 20.93 22.8604 19.98 22.9504 18.99C22.9604 18.99 22.9604 18.97 22.9604 18.96C22.9804 18.89 22.9804 18.81 22.9804 18.74C22.9804 18.73 22.9904 18.71 22.9904 18.69C23.0504 17.48 22.6104 16.24 21.6804 15.32ZM20.2304 20.21C19.9404 20.5 19.4704 20.5 19.1704 20.21L18.5104 19.55L17.8304 20.23C17.5304 20.53 17.0604 20.53 16.7704 20.23C16.4704 19.94 16.4704 19.47 16.7704 19.17L17.4504 18.49L16.7904 17.83C16.5004 17.53 16.5004 17.06 16.7904 16.77C17.0904 16.47 17.5604 16.47 17.8604 16.77L18.5104 17.43L19.1404 16.79C19.4404 16.5 19.9104 16.5 20.2104 16.79C20.5004 17.09 20.5004 17.56 20.2104 17.86L19.5704 18.49L20.2304 19.14C20.5304 19.44 20.5304 19.91 20.2304 20.21Z"
                                            fill="#FB4E4E"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-normal text-sm leading-6 capitalize text-paragraph">
                                        {{ __('dashboard.canceled') }}</h3>
                                    <h4 class="font-bold text-lg leading-[34px]" id="canceled">
                                        {{ @$order_statistics->cancel ?? 0 }}</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 sm:col-6 md:col-4 lg:col-6 xl:col-3">
                            <div class="flex items-center gap-4 p-4 rounded-lg shadow-xs bg-white">
                                <div class="w-12 h-12 rounded-full flex items-center justify-center bg-[#FFEAEA]">
                                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M17.6005 5.31L11.9505 2.27C11.3505 1.95 10.6405 1.95 10.0405 2.27L4.40047 5.31C3.99047 5.54 3.73047 5.98 3.73047 6.46C3.73047 6.95 3.98047 7.39 4.40047 7.61L10.0505 10.65C10.3505 10.81 10.6805 10.89 11.0005 10.89C11.3205 10.89 11.6605 10.81 11.9505 10.65L17.6005 7.61C18.0105 7.39 18.2705 6.95 18.2705 6.46C18.2705 5.98 18.0105 5.54 17.6005 5.31Z"
                                            fill="#FB4E4E"></path>
                                        <path
                                            d="M9.12 11.71L3.87 9.09C3.46 8.88 3 8.91 2.61 9.14C2.23 9.38 2 9.79 2 10.24V15.2C2 16.06 2.48 16.83 3.25 17.22L8.5 19.84C8.68 19.93 8.88 19.98 9.08 19.98C9.31 19.98 9.55 19.91 9.76 19.79C10.14 19.55 10.37 19.14 10.37 18.69V13.73C10.36 12.87 9.88 12.1 9.12 11.71Z"
                                            fill="#FB4E4E"></path>
                                        <path
                                            d="M19.9996 10.24V12.7C19.5196 12.56 19.0096 12.5 18.4996 12.5C17.1396 12.5 15.8096 12.97 14.7596 13.81C13.3196 14.94 12.4996 16.65 12.4996 18.5C12.4996 18.99 12.5596 19.48 12.6896 19.95C12.5396 19.93 12.3896 19.87 12.2496 19.78C11.8696 19.55 11.6396 19.14 11.6396 18.69V13.73C11.6396 12.87 12.1196 12.1 12.8796 11.71L18.1296 9.09C18.5396 8.88 18.9996 8.91 19.3896 9.14C19.7696 9.38 19.9996 9.79 19.9996 10.24Z"
                                            fill="#FB4E4E"></path>
                                        <path
                                            d="M21.6804 15.32C20.7904 14.43 19.6104 13.98 18.4404 14C17.3104 14.01 16.1804 14.46 15.3204 15.32C14.7204 15.91 14.3304 16.65 14.1404 17.42C14.0304 17.84 13.9904 18.27 14.0204 18.7V18.75C14.0204 18.82 14.0304 18.88 14.0404 18.96C14.0404 18.96 14.0404 18.96 14.0504 18.97V19C14.1404 19.98 14.5604 20.93 15.3204 21.68C16.4804 22.84 18.1104 23.23 19.5804 22.86C20.0204 22.75 20.4504 22.57 20.8504 22.33C21.1504 22.16 21.4304 21.94 21.6804 21.68C22.4304 20.93 22.8604 19.98 22.9504 18.99C22.9604 18.99 22.9604 18.97 22.9604 18.96C22.9804 18.89 22.9804 18.81 22.9804 18.74C22.9804 18.73 22.9904 18.71 22.9904 18.69C23.0504 17.48 22.6104 16.24 21.6804 15.32ZM20.2304 20.21C19.9404 20.5 19.4704 20.5 19.1704 20.21L18.5104 19.55L17.8304 20.23C17.5304 20.53 17.0604 20.53 16.7704 20.23C16.4704 19.94 16.4704 19.47 16.7704 19.17L17.4504 18.49L16.7904 17.83C16.5004 17.53 16.5004 17.06 16.7904 16.77C17.0904 16.47 17.5604 16.47 17.8604 16.77L18.5104 17.43L19.1404 16.79C19.4404 16.5 19.9104 16.5 20.2104 16.79C20.5004 17.09 20.5004 17.56 20.2104 17.86L19.5704 18.49L20.2304 19.14C20.5304 19.44 20.5304 19.91 20.2304 20.21Z"
                                            fill="#FB4E4E"></path>
                                    </svg>
                                </div>
                                <div>
                                    <h3 class="font-normal text-sm leading-6 capitalize text-paragraph">
                                        {{ __('dashboard.rejected') }}</h3>
                                    <h4 class="font-bold text-lg leading-[34px]" id="rejected">
                                        {{ @$order_statistics->reject ?? 0 }}</h4>
                                </div>
                            </div>
                        </div>

                    @elseif (auth()->user()->myrole == App\Enums\UserRole::DELIVERYBOY)
                        <div class="col-12 sm:col-12 p-3">
                            <div class="row">
                                <div class="col-12">
                                    <div class="flex items-center justify-between mb-4">
                                        <h4 class="font-semibold text-[22px] leading-[34px] mb-3 capitalize">
                                            {{ __('dashboard.order_statistics') }}</h4>
                                        <div id="orderDateRange"
                                            class="min-w-[150px] cursor-pointer py-2 px-4 rounded-lg flex items-center gap-3 border border-primary bg-primary-light">
                                            <span class="capitalize text-base text-primary"></span>
                                            <svg class="fill-primary" width="16" height="16" viewBox="0 0 16 16"
                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M11.9465 5.45312H7.79316H4.05317C3.41317 5.45312 3.09317 6.22646 3.5465 6.67979L6.99983 10.1331C7.55317 10.6865 8.45317 10.6865 9.0065 10.1331L10.3198 8.81979L12.4598 6.67979C12.9065 6.22646 12.5865 5.45312 11.9465 5.45312Z">
                                                </path>
                                            </svg>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 sm:col-12 md:col-4 lg:col-4 xl:col-4">
                                    <div class="flex items-center gap-4 p-4 rounded-lg shadow-xs"
                                        style="background-color: #ff8c39;">
                                        <div class="w-12 h-12 rounded-full flex items-center justify-center bg-[#FFE6F0]">
                                            <div class="card-icon bg-primary">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="#ff8c39" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M12.75 15.92H13.4C14.05 15.92 14.59 15.34 14.59 14.64C14.59 13.77 14.28 13.6 13.77 13.42L12.76 13.07V15.92H12.75Z"></path>
                                                    <path d="M11.9701 1.89998C6.45007 1.91998 1.98007 6.40998 2.00007 11.93C2.02007 17.45 6.51007 21.92 12.0301 21.9C17.5501 21.88 22.0201 17.39 22.0001 11.87C21.9801 6.34998 17.4901 1.88998 11.9701 1.89998ZM14.2601 12C15.0401 12.27 16.0901 12.85 16.0901 14.64C16.0901 16.18 14.8801 17.42 13.4001 17.42H12.7501V18C12.7501 18.41 12.4101 18.75 12.0001 18.75C11.5901 18.75 11.2501 18.41 11.2501 18V17.42H10.8901C9.25007 17.42 7.92007 16.04 7.92007 14.34C7.92007 13.93 8.26007 13.59 8.67007 13.59C9.08007 13.59 9.42007 13.93 9.42007 14.34C9.42007 15.21 10.0801 15.92 10.8901 15.92H11.2501V12.54L9.74007 12C8.96007 11.73 7.91007 11.15 7.91007 9.35998C7.91007 7.81998 9.12007 6.57998 10.6001 6.57998H11.2501V5.99998C11.2501 5.58998 11.5901 5.24998 12.0001 5.24998C12.4101 5.24998 12.7501 5.58998 12.7501 5.99998V6.57998H13.1101C14.7501 6.57998 16.0801 7.95998 16.0801 9.65998C16.0801 10.07 15.7401 10.41 15.3301 10.41C14.9201 10.41 14.5801 10.07 14.5801 9.65998C14.5801 8.78998 13.9201 8.07998 13.1101 8.07998H12.7501V11.46L14.2601 12Z"></path>
                                                    <path d="M9.41992 9.37002C9.41992 10.24 9.72992 10.41 10.2399 10.59L11.2499 10.94V8.08002H10.5999C9.94992 8.08002 9.41992 8.66002 9.41992 9.37002Z"></path>
                                                </svg>
                                            </div>

                                        </div>
                                        <div>
                                            <h3 class="font-bold text-sm leading-6 capitalize text-white">
                                                {{ __('dashboard.total_earnings') }}</h3>
                                            <h4 class="font-bold text-lg leading-[34px] text-white" id="totalEarning">
                                                {{ setting('currency_code') . ' ' . @$order_statistics->delivery_boy_total_earnings ?? 0 }}
                                            </h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 sm:col-12 md:col-4 lg:col-4 xl:col-4">
                                    <div class="flex items-center gap-4 p-4 rounded-lg shadow-xs"
                                        style="background-color: #8262fe;">
                                        <div class="w-12 h-12 rounded-full flex items-center justify-center bg-[#FFE6F0]">
                                            <div class="card-icon bg-primary">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M20.2083 7.81994L12.5083 12.2799C12.1983 12.4599 11.8083 12.4599 11.4883 12.2799L3.78826 7.81994C3.23826 7.49994 3.09826 6.74994 3.51826 6.27994C3.80826 5.94994 4.13826 5.67994 4.48826 5.48994L9.90826 2.48994C11.0683 1.83994 12.9483 1.83994 14.1083 2.48994L19.5283 5.48994C19.8783 5.67994 20.2083 5.95994 20.4983 6.27994C20.8983 6.74994 20.7583 7.49994 20.2083 7.81994Z"
                                                        fill="#8262FE" />
                                                    <path
                                                        d="M11.4305 14.14V20.96C11.4305 21.72 10.6605 22.22 9.98047 21.89C7.92047 20.88 4.45047 18.99 4.45047 18.99C3.23047 18.3 2.23047 16.56 2.23047 15.13V9.97C2.23047 9.18 3.06047 8.68 3.74047 9.07L10.9305 13.24C11.2305 13.43 11.4305 13.77 11.4305 14.14Z"
                                                        fill="#8262FE" />
                                                    <path
                                                        d="M12.5703 14.14V20.96C12.5703 21.72 13.3403 22.22 14.0203 21.89C16.0803 20.88 19.5503 18.99 19.5503 18.99C20.7703 18.3 21.7703 16.56 21.7703 15.13V9.97C21.7703 9.18 20.9403 8.68 20.2603 9.07L13.0703 13.24C12.7703 13.43 12.5703 13.77 12.5703 14.14Z"
                                                        fill="#8262FE" />
                                                </svg>
                                            </div>

                                        </div>
                                        <div>
                                            <h3 class="font-bold text-sm leading-6 capitalize text-white">
                                                {{ __('dashboard.total_accepted_orders') }}</h3>
                                            <h4 class="font-bold text-lg leading-[34px] text-white"
                                                id="totalAcceptedOrders">
                                                {{ @$order_statistics->deliveryBoy_totalEarnings ?? 0 }}</h4>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 sm:col-12 md:col-4 lg:col-4 xl:col-4">
                                    <div class="flex items-center gap-4 p-4 rounded-lg shadow-xs"
                                        style="background-color: #567dff;">
                                        <div class="w-12 h-12 rounded-full flex items-center justify-center bg-[#FFE6F0]">
                                            <div class="card-icon bg-primary">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M17.6005 5.31003L11.9505 2.27003C11.3505 1.95003 10.6405 1.95003 10.0405 2.27003L4.40047 5.31003C3.99047 5.54003 3.73047 5.98003 3.73047 6.46003C3.73047 6.95003 3.98047 7.39003 4.40047 7.61003L10.0505 10.65C10.3505 10.81 10.6805 10.89 11.0005 10.89C11.3205 10.89 11.6605 10.81 11.9505 10.65L17.6005 7.61003C18.0105 7.39003 18.2705 6.95003 18.2705 6.46003C18.2705 5.98003 18.0105 5.54003 17.6005 5.31003Z"
                                                        fill="#567DFF" />
                                                    <path
                                                        d="M9.12 11.7101L3.87 9.09009C3.46 8.88009 3 8.91009 2.61 9.14009C2.23 9.38009 2 9.79009 2 10.2401V15.2001C2 16.0601 2.48 16.8301 3.25 17.2201L8.5 19.8401C8.68 19.9301 8.88 19.9801 9.08 19.9801C9.31 19.9801 9.55 19.9101 9.76 19.7901C10.14 19.5501 10.37 19.1401 10.37 18.6901V13.7301C10.36 12.8701 9.88 12.1001 9.12 11.7101Z"
                                                        fill="#567DFF" />
                                                    <path
                                                        d="M20.0006 10.2401V12.7001C19.5206 12.5601 19.0106 12.5001 18.5006 12.5001C17.1406 12.5001 15.8106 12.9701 14.7606 13.8101C13.3206 14.9401 12.5006 16.6501 12.5006 18.5001C12.5006 18.9901 12.5606 19.4801 12.6906 19.9501C12.5406 19.9301 12.3906 19.8701 12.2506 19.7801C11.8706 19.5501 11.6406 19.1401 11.6406 18.6901V13.7301C11.6406 12.8701 12.1206 12.1001 12.8806 11.7101L18.1306 9.09009C18.5406 8.88009 19.0006 8.91009 19.3906 9.14009C19.7706 9.38009 20.0006 9.79009 20.0006 10.2401Z"
                                                        fill="#567DFF" />
                                                    <path
                                                        d="M21.98 15.67C21.16 14.66 19.91 14.02 18.5 14.02C17.44 14.02 16.46 14.39 15.69 15.01C14.65 15.83 14 17.1 14 18.52C14 19.36 14.24 20.16 14.65 20.84C14.92 21.29 15.26 21.68 15.66 22H15.67C16.44 22.64 17.43 23.02 18.5 23.02C19.64 23.02 20.67 22.6 21.46 21.9C21.81 21.6 22.11 21.24 22.35 20.84C22.76 20.16 23 19.36 23 18.52C23 17.44 22.62 16.44 21.98 15.67ZM20.76 17.96L18.36 20.18C18.22 20.31 18.03 20.38 17.85 20.38C17.66 20.38 17.47 20.31 17.32 20.16L16.21 19.05C15.92 18.76 15.92 18.28 16.21 17.99C16.5 17.7 16.98 17.7 17.27 17.99L17.87 18.59L19.74 16.86C20.04 16.58 20.52 16.6 20.8 16.9C21.09 17.21 21.07 17.68 20.76 17.96Z"
                                                        fill="#567DFF" />
                                                </svg>
                                            </div>

                                        </div>
                                        <div>
                                            <h3 class="font-bold text-sm leading-6 capitalize text-white">
                                                {{ __('dashboard.complete_deliery') }}</h3>
                                            <h4 class="font-bold text-lg leading-[34px] text-white" id="completeDelivery">
                                                {{ @$order_statistics->deliveryBoy_totalAcceptedOrders ?? 0 }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
                <div class="row mt-4">
                    @if (auth()->user()->myrole == App\Enums\UserRole::ADMIN || (auth()->user()->myrole == App\Enums\UserRole::RESTAURANTOWNER && auth()->user()->restaurant->id))
                        <div class="col-12 xl:col-6">
                            <div class="db-card">
                                <div class="db-card-header">
                                    <h3 class="db-card-title">{{ __('dashboard.sales_summary') }}</h3>
                                    <div id="salesDateRange" class="cursor-pointer flex items-center gap-3">
                                        <span class="capitalize text-base font-medium text-heading"></span>
                                        <svg class="fill-primary" width="24" height="24" viewBox="0 0 24 24"
                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M16.7502 3.56V2C16.7502 1.59 16.4102 1.25 16.0002 1.25C15.5902 1.25 15.2502 1.59 15.2502 2V3.5H8.75023V2C8.75023 1.59 8.41023 1.25 8.00023 1.25C7.59023 1.25 7.25023 1.59 7.25023 2V3.56C4.55023 3.81 3.24023 5.42 3.04023 7.81C3.02023 8.1 3.26023 8.34 3.54023 8.34H20.4602C20.7502 8.34 20.9902 8.09 20.9602 7.81C20.7602 5.42 19.4502 3.81 16.7502 3.56Z"
                                                fill="#FF006B"></path>
                                            <path opacity="0.4"
                                                d="M20 9.84C20.55 9.84 21 10.29 21 10.84V17C21 20 19.5 22 16 22H8C4.5 22 3 20 3 17V10.84C3 10.29 3.45 9.84 4 9.84H20Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M8.5 15C8.24 15 7.98 14.89 7.79 14.71C7.61 14.52 7.5 14.26 7.5 14C7.5 13.74 7.61 13.48 7.79 13.29C8.07 13.01 8.51 12.92 8.88 13.08C9.01 13.13 9.12 13.2 9.21 13.29C9.39 13.48 9.5 13.74 9.5 14C9.5 14.26 9.39 14.52 9.21 14.71C9.02 14.89 8.76 15 8.5 15Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M12 15C11.74 15 11.48 14.89 11.29 14.71C11.11 14.52 11 14.26 11 14C11 13.74 11.11 13.48 11.29 13.29C11.38 13.2 11.49 13.13 11.62 13.08C11.99 12.92 12.43 13.01 12.71 13.29C12.89 13.48 13 13.74 13 14C13 14.26 12.89 14.52 12.71 14.71C12.66 14.75 12.61 14.79 12.56 14.83C12.5 14.87 12.44 14.9 12.38 14.92C12.32 14.95 12.26 14.97 12.2 14.98C12.13 14.99 12.07 15 12 15Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M15.5 15C15.24 15 14.98 14.89 14.79 14.71C14.61 14.52 14.5 14.26 14.5 14C14.5 13.74 14.61 13.48 14.79 13.29C14.89 13.2 14.99 13.13 15.12 13.08C15.3 13 15.5 12.98 15.7 13.02C15.76 13.03 15.82 13.05 15.88 13.08C15.94 13.1 16 13.13 16.06 13.17C16.11 13.21 16.16 13.25 16.21 13.29C16.39 13.48 16.5 13.74 16.5 14C16.5 14.26 16.39 14.52 16.21 14.71C16.16 14.75 16.11 14.79 16.06 14.83C16 14.87 15.94 14.9 15.88 14.92C15.82 14.95 15.76 14.97 15.7 14.98C15.63 14.99 15.56 15 15.5 15Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M8.5 18.5C8.37 18.5 8.24 18.47 8.12 18.42C7.99 18.37 7.89 18.3 7.79 18.21C7.61 18.02 7.5 17.76 7.5 17.5C7.5 17.24 7.61 16.98 7.79 16.79C7.89 16.7 7.99 16.63 8.12 16.58C8.3 16.5 8.5 16.48 8.7 16.52C8.76 16.53 8.82 16.55 8.88 16.58C8.94 16.6 9 16.63 9.06 16.67C9.11 16.71 9.16 16.75 9.21 16.79C9.39 16.98 9.5 17.24 9.5 17.5C9.5 17.76 9.39 18.02 9.21 18.21C9.16 18.25 9.11 18.3 9.06 18.33C9 18.37 8.94 18.4 8.88 18.42C8.82 18.45 8.76 18.47 8.7 18.48C8.63 18.49 8.57 18.5 8.5 18.5Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M12 18.5C11.74 18.5 11.48 18.39 11.29 18.21C11.11 18.02 11 17.76 11 17.5C11 17.24 11.11 16.98 11.29 16.79C11.66 16.42 12.34 16.42 12.71 16.79C12.89 16.98 13 17.24 13 17.5C13 17.76 12.89 18.02 12.71 18.21C12.52 18.39 12.26 18.5 12 18.5Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M15.5 18.5C15.24 18.5 14.98 18.39 14.79 18.21C14.61 18.02 14.5 17.76 14.5 17.5C14.5 17.24 14.61 16.98 14.79 16.79C15.16 16.42 15.84 16.42 16.21 16.79C16.39 16.98 16.5 17.24 16.5 17.5C16.5 17.76 16.39 18.02 16.21 18.21C16.02 18.39 15.76 18.5 15.5 18.5Z"
                                                fill="#FF006B"></path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="db-card-body">
                                    <ul class="flex gap-11">
                                        <li>
                                            <div class="flex items-center gap-2.5">
                                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M1.66699 18.3333H18.3337" stroke="#A0A3BD" stroke-width="1.5"
                                                        stroke-miterlimit="10" stroke-linecap="round"
                                                        stroke-linejoin="round"></path>
                                                    <path
                                                        d="M8.125 3.33332V18.3333H11.875V3.33332C11.875 2.41666 11.5 1.66666 10.375 1.66666H9.625C8.5 1.66666 8.125 2.41666 8.125 3.33332Z"
                                                        stroke="#A0A3BD" stroke-width="1.5" stroke-linecap="round"
                                                        stroke-linejoin="round"></path>
                                                    <path
                                                        d="M2.5 8.33332V18.3333H5.83333V8.33332C5.83333 7.41666 5.5 6.66666 4.5 6.66666H3.83333C2.83333 6.66666 2.5 7.41666 2.5 8.33332Z"
                                                        stroke="#A0A3BD" stroke-width="1.5" stroke-linecap="round"
                                                        stroke-linejoin="round"></path>
                                                    <path
                                                        d="M14.167 12.5V18.3333H17.5003V12.5C17.5003 11.5833 17.167 10.8333 16.167 10.8333H15.5003C14.5003 10.8333 14.167 11.5833 14.167 12.5Z"
                                                        stroke="#A0A3BD" stroke-width="1.5" stroke-linecap="round"
                                                        stroke-linejoin="round"></path>
                                                </svg>
                                                <h3 class="font-bold text-[22px] leading-[34px]" id="totalSales"></h3>
                                            </div>
                                            <p class="text-xs capitalize">{{ __('dashboard.total_sales') }}</p>
                                        </li>
                                        <li>
                                            <div class="flex items-center gap-2.5">
                                                <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M1.66699 18.3333H18.3337" stroke="#A0A3BD" stroke-width="1.5"
                                                        stroke-miterlimit="10" stroke-linecap="round"
                                                        stroke-linejoin="round"></path>
                                                    <path
                                                        d="M8.125 3.33332V18.3333H11.875V3.33332C11.875 2.41666 11.5 1.66666 10.375 1.66666H9.625C8.5 1.66666 8.125 2.41666 8.125 3.33332Z"
                                                        stroke="#A0A3BD" stroke-width="1.5" stroke-linecap="round"
                                                        stroke-linejoin="round"></path>
                                                    <path
                                                        d="M2.5 8.33332V18.3333H5.83333V8.33332C5.83333 7.41666 5.5 6.66666 4.5 6.66666H3.83333C2.83333 6.66666 2.5 7.41666 2.5 8.33332Z"
                                                        stroke="#A0A3BD" stroke-width="1.5" stroke-linecap="round"
                                                        stroke-linejoin="round"></path>
                                                    <path
                                                        d="M14.167 12.5V18.3333H17.5003V12.5C17.5003 11.5833 17.167 10.8333 16.167 10.8333H15.5003C14.5003 10.8333 14.167 11.5833 14.167 12.5Z"
                                                        stroke="#A0A3BD" stroke-width="1.5" stroke-linecap="round"
                                                        stroke-linejoin="round"></path>
                                                </svg>
                                                <h3 class="font-bold text-[22px] leading-[34px]" id="avgSales"></h3>
                                            </div>
                                            <p class="text-xs capitalize">{{ __('dashboard.avg_sales') }}</p>
                                        </li>
                                    </ul>
                                    <div id="salesChart" style="min-height: 250px;"></div>
                                </div>
                            </div>
                        </div>

                        <!-- Orders summary -->
                        <div class="col-12 xl:col-6">
                            <div class="db-card">
                                <div class="db-card-header">
                                    <h3 class="db-card-title">{{ __('dashboard.order_summary') }}</h3>
                                    <div id="orderSummaryDateRange" class="cursor-pointer flex items-center gap-3">
                                        <span class="capitalize text-base font-medium text-heading">test</span>
                                        <svg class="fill-primary" width="24" height="24" viewBox="0 0 24 24"
                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M16.7502 3.56V2C16.7502 1.59 16.4102 1.25 16.0002 1.25C15.5902 1.25 15.2502 1.59 15.2502 2V3.5H8.75023V2C8.75023 1.59 8.41023 1.25 8.00023 1.25C7.59023 1.25 7.25023 1.59 7.25023 2V3.56C4.55023 3.81 3.24023 5.42 3.04023 7.81C3.02023 8.1 3.26023 8.34 3.54023 8.34H20.4602C20.7502 8.34 20.9902 8.09 20.9602 7.81C20.7602 5.42 19.4502 3.81 16.7502 3.56Z"
                                                fill="#FF006B"></path>
                                            <path opacity="0.4"
                                                d="M20 9.84C20.55 9.84 21 10.29 21 10.84V17C21 20 19.5 22 16 22H8C4.5 22 3 20 3 17V10.84C3 10.29 3.45 9.84 4 9.84H20Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M8.5 15C8.24 15 7.98 14.89 7.79 14.71C7.61 14.52 7.5 14.26 7.5 14C7.5 13.74 7.61 13.48 7.79 13.29C8.07 13.01 8.51 12.92 8.88 13.08C9.01 13.13 9.12 13.2 9.21 13.29C9.39 13.48 9.5 13.74 9.5 14C9.5 14.26 9.39 14.52 9.21 14.71C9.02 14.89 8.76 15 8.5 15Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M12 15C11.74 15 11.48 14.89 11.29 14.71C11.11 14.52 11 14.26 11 14C11 13.74 11.11 13.48 11.29 13.29C11.38 13.2 11.49 13.13 11.62 13.08C11.99 12.92 12.43 13.01 12.71 13.29C12.89 13.48 13 13.74 13 14C13 14.26 12.89 14.52 12.71 14.71C12.66 14.75 12.61 14.79 12.56 14.83C12.5 14.87 12.44 14.9 12.38 14.92C12.32 14.95 12.26 14.97 12.2 14.98C12.13 14.99 12.07 15 12 15Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M15.5 15C15.24 15 14.98 14.89 14.79 14.71C14.61 14.52 14.5 14.26 14.5 14C14.5 13.74 14.61 13.48 14.79 13.29C14.89 13.2 14.99 13.13 15.12 13.08C15.3 13 15.5 12.98 15.7 13.02C15.76 13.03 15.82 13.05 15.88 13.08C15.94 13.1 16 13.13 16.06 13.17C16.11 13.21 16.16 13.25 16.21 13.29C16.39 13.48 16.5 13.74 16.5 14C16.5 14.26 16.39 14.52 16.21 14.71C16.16 14.75 16.11 14.79 16.06 14.83C16 14.87 15.94 14.9 15.88 14.92C15.82 14.95 15.76 14.97 15.7 14.98C15.63 14.99 15.56 15 15.5 15Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M8.5 18.5C8.37 18.5 8.24 18.47 8.12 18.42C7.99 18.37 7.89 18.3 7.79 18.21C7.61 18.02 7.5 17.76 7.5 17.5C7.5 17.24 7.61 16.98 7.79 16.79C7.89 16.7 7.99 16.63 8.12 16.58C8.3 16.5 8.5 16.48 8.7 16.52C8.76 16.53 8.82 16.55 8.88 16.58C8.94 16.6 9 16.63 9.06 16.67C9.11 16.71 9.16 16.75 9.21 16.79C9.39 16.98 9.5 17.24 9.5 17.5C9.5 17.76 9.39 18.02 9.21 18.21C9.16 18.25 9.11 18.3 9.06 18.33C9 18.37 8.94 18.4 8.88 18.42C8.82 18.45 8.76 18.47 8.7 18.48C8.63 18.49 8.57 18.5 8.5 18.5Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M12 18.5C11.74 18.5 11.48 18.39 11.29 18.21C11.11 18.02 11 17.76 11 17.5C11 17.24 11.11 16.98 11.29 16.79C11.66 16.42 12.34 16.42 12.71 16.79C12.89 16.98 13 17.24 13 17.5C13 17.76 12.89 18.02 12.71 18.21C12.52 18.39 12.26 18.5 12 18.5Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M15.5 18.5C15.24 18.5 14.98 18.39 14.79 18.21C14.61 18.02 14.5 17.76 14.5 17.5C14.5 17.24 14.61 16.98 14.79 16.79C15.16 16.42 15.84 16.42 16.21 16.79C16.39 16.98 16.5 17.24 16.5 17.5C16.5 17.76 16.39 18.02 16.21 18.21C16.02 18.39 15.76 18.5 15.5 18.5Z"
                                                fill="#FF006B"></path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="db-card-body">
                                    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-5">
                                        <div id="orderSummaryChart" style="min-height: 298.7px; width: 100%;"></div>
                                        <ul class="flex flex-col gap-8 sm:w-10" style="width: 60%;">
                                            <li class="w-full">
                                                <span
                                                    class="block capitalize mb-1 text-heading">{{ __('dashboard.delivered') }}
                                                    ( <span id="deliveredIndicator"></span> )</span>
                                                <span class="block w-full h-2 rounded bg-[#FF4F99]"></span>
                                            </li>
                                            <li class="w-full">
                                                <span
                                                    class="block capitalize mb-1 text-heading">{{ __('dashboard.canceled') }}
                                                    ( <span id="canceledIndicator"></span> )</span>
                                                <span class="block w-full h-2 rounded bg-[#A953FF]"></span>
                                            </li>
                                            <li class="w-full">
                                                <span
                                                    class="block capitalize mb-1 text-heading">{{ __('dashboard.rejected') }}
                                                    ( <span id="rejectedIndicator"></span> )</span>
                                                <span class="block w-full h-2 rounded bg-[#FB4E4E]"></span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Revenue -->
                        <div class="col-12 xl:col-6">
                            <div class="db-card">
                                <div class="db-card-header">
                                    <h3 class="db-card-title">
                                        {{ auth()->user()->myrole == App\Enums\UserRole::ADMIN ? __('dashboard.revenue') : __('dashboard.customer_stats') }}
                                    </h3>
                                    <div id="revenueDateRange" class="cursor-pointer flex items-center gap-3">
                                        <span class="capitalize text-base font-medium text-heading"></span>
                                        <svg class="fill-primary" width="24" height="24" viewBox="0 0 24 24"
                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M16.7502 3.56V2C16.7502 1.59 16.4102 1.25 16.0002 1.25C15.5902 1.25 15.2502 1.59 15.2502 2V3.5H8.75023V2C8.75023 1.59 8.41023 1.25 8.00023 1.25C7.59023 1.25 7.25023 1.59 7.25023 2V3.56C4.55023 3.81 3.24023 5.42 3.04023 7.81C3.02023 8.1 3.26023 8.34 3.54023 8.34H20.4602C20.7502 8.34 20.9902 8.09 20.9602 7.81C20.7602 5.42 19.4502 3.81 16.7502 3.56Z"
                                                fill="#FF006B"></path>
                                            <path opacity="0.4"
                                                d="M20 9.84C20.55 9.84 21 10.29 21 10.84V17C21 20 19.5 22 16 22H8C4.5 22 3 20 3 17V10.84C3 10.29 3.45 9.84 4 9.84H20Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M8.5 15C8.24 15 7.98 14.89 7.79 14.71C7.61 14.52 7.5 14.26 7.5 14C7.5 13.74 7.61 13.48 7.79 13.29C8.07 13.01 8.51 12.92 8.88 13.08C9.01 13.13 9.12 13.2 9.21 13.29C9.39 13.48 9.5 13.74 9.5 14C9.5 14.26 9.39 14.52 9.21 14.71C9.02 14.89 8.76 15 8.5 15Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M12 15C11.74 15 11.48 14.89 11.29 14.71C11.11 14.52 11 14.26 11 14C11 13.74 11.11 13.48 11.29 13.29C11.38 13.2 11.49 13.13 11.62 13.08C11.99 12.92 12.43 13.01 12.71 13.29C12.89 13.48 13 13.74 13 14C13 14.26 12.89 14.52 12.71 14.71C12.66 14.75 12.61 14.79 12.56 14.83C12.5 14.87 12.44 14.9 12.38 14.92C12.32 14.95 12.26 14.97 12.2 14.98C12.13 14.99 12.07 15 12 15Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M15.5 15C15.24 15 14.98 14.89 14.79 14.71C14.61 14.52 14.5 14.26 14.5 14C14.5 13.74 14.61 13.48 14.79 13.29C14.89 13.2 14.99 13.13 15.12 13.08C15.3 13 15.5 12.98 15.7 13.02C15.76 13.03 15.82 13.05 15.88 13.08C15.94 13.1 16 13.13 16.06 13.17C16.11 13.21 16.16 13.25 16.21 13.29C16.39 13.48 16.5 13.74 16.5 14C16.5 14.26 16.39 14.52 16.21 14.71C16.16 14.75 16.11 14.79 16.06 14.83C16 14.87 15.94 14.9 15.88 14.92C15.82 14.95 15.76 14.97 15.7 14.98C15.63 14.99 15.56 15 15.5 15Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M8.5 18.5C8.37 18.5 8.24 18.47 8.12 18.42C7.99 18.37 7.89 18.3 7.79 18.21C7.61 18.02 7.5 17.76 7.5 17.5C7.5 17.24 7.61 16.98 7.79 16.79C7.89 16.7 7.99 16.63 8.12 16.58C8.3 16.5 8.5 16.48 8.7 16.52C8.76 16.53 8.82 16.55 8.88 16.58C8.94 16.6 9 16.63 9.06 16.67C9.11 16.71 9.16 16.75 9.21 16.79C9.39 16.98 9.5 17.24 9.5 17.5C9.5 17.76 9.39 18.02 9.21 18.21C9.16 18.25 9.11 18.3 9.06 18.33C9 18.37 8.94 18.4 8.88 18.42C8.82 18.45 8.76 18.47 8.7 18.48C8.63 18.49 8.57 18.5 8.5 18.5Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M12 18.5C11.74 18.5 11.48 18.39 11.29 18.21C11.11 18.02 11 17.76 11 17.5C11 17.24 11.11 16.98 11.29 16.79C11.66 16.42 12.34 16.42 12.71 16.79C12.89 16.98 13 17.24 13 17.5C13 17.76 12.89 18.02 12.71 18.21C12.52 18.39 12.26 18.5 12 18.5Z"
                                                fill="#FF006B"></path>
                                            <path
                                                d="M15.5 18.5C15.24 18.5 14.98 18.39 14.79 18.21C14.61 18.02 14.5 17.76 14.5 17.5C14.5 17.24 14.61 16.98 14.79 16.79C15.16 16.42 15.84 16.42 16.21 16.79C16.39 16.98 16.5 17.24 16.5 17.5C16.5 17.76 16.39 18.02 16.21 18.21C16.02 18.39 15.76 18.5 15.5 18.5Z"
                                                fill="#FF006B"></path>
                                        </svg>
                                    </div>
                                </div>
                                <div class="db-card-body">
                                    <div id="revenueChart" style="min-height: 276px;">

                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                    @if (auth()->user()->myrole == App\Enums\UserRole::ADMIN || (auth()->user()->myrole == App\Enums\UserRole::RESTAURANTOWNER && auth()->user()->restaurant->id) && isset($topCustomers))
                        <div class="col-12 xl:col-6">
                            <div class="db-card">
                                <div class="db-card-header">
                                    <h3 class="db-card-title">{{ __('dashboard.top_customers') }}</h3>
                                </div>
                                <div class="db-card-body">
                                    <ul class="grid grid-cols-2 sm:grid-cols-4 gap-4">
                                        @forelse ($topCustomers as $customer)
                                            <li class="w-full rounded-xl pt-3 border border-[#D9DBE9] relative" style="padding-bottom: 24px;">
                                                <img class="w-12 mx-auto rounded-full mb-2"
                                                    src="{{ $customer->user->image }}" alt="avatar">
                                                <h4
                                                    class="text-sm px-3 text-center font-medium capitalize mb-4 whitespace-nowrap overflow-hidden text-ellipsis">
                                                    {{ $customer->user->name }}</h4>
                                                <p
                                                    class="text-xs w-full tracking-wide text-center py-1 rounded-t rounded-b-[11px] text-white bg-[#008BBA] absolute bottom-0">
                                                    {{ $customer->total_orders }} {{ __('dashboard.orders') }}</p>
                                            </li>
                                        @empty
                                        @endforelse
                                    </ul>
                                </div>
                            </div>
                        </div>
                    @endif

                    @if (isset($topDeliveryMan))
                        <div class="col-12 xl:col-6">
                            <div class="db-card">
                                <div class="db-card-header">
                                    <h3 class="db-card-title">{{ __('dashboard.top_delivery_man') }}</h3>
                                </div>
                                <div class="db-card-body">
                                    <ul class="grid grid-cols-2 sm:grid-cols-4 gap-4">
                                        @forelse ($topDeliveryMan as $deliveryMan)
                                            <li class="w-full rounded-xl pt-3 border border-[#D9DBE9] relative" style="padding-bottom: 24px;">
                                                <img class="w-12 mx-auto rounded-full mb-2"
                                                    src="{{ optional($deliveryMan->delivery)->image }}" alt="avatar">
                                                <h4
                                                    class="text-sm px-3 text-center font-medium capitalize mb-4 whitespace-nowrap overflow-hidden text-ellipsis">
                                                    {{ optional($deliveryMan->delivery)->name }}</h4>
                                                <p
                                                    class="text-xs w-full tracking-wide text-center py-1 rounded-t rounded-b-[11px] text-white bg-[#008BBA] absolute bottom-0">
                                                    {{ $deliveryMan->total_orders }} {{ __('dashboard.orders') }}</p>
                                            </li>

                                        @empty
                                        @endforelse
                                    </ul>
                                </div>
                            </div>
                        </div>
                    @endif

                    @if (isset($topRestaurants))
                        <div class="col-12 xl:col-6">
                            <div class="db-card">
                                <div class="db-card-header">
                                    <div class="db-card-title">{{ __('dashboard.most_popular_restaurants') }}</div>
                                </div>
                                <div class="db-card-body">
                                    <ul class="grid grid-cols-1 sm:grid-cols-2 gap-[18px]">
                                        @forelse ($topRestaurants as $topRestaurant)
                                            <li class="w-full flex rounded-xl border border-[#D9DBE9]">
                                                <img class="flex w-20 h-20 object-cover rounded-l-[11px]"
                                                    src="{{ optional($topRestaurant->restaurant)->image }}" alt="product">
                                                <div class="py-2 px-3 flex flex-col justify-between overflow-hidden">
                                                    <h4
                                                        class="text-sm overflow-hidden whitespace-nowrap text-ellipsis font-medium capitalize">
                                                        {{ optional($topRestaurant->restaurant)->name }}</h4>
                                                    <h5 class="text-xs font-medium capitalize text-[#008BBA]">
                                                        {{ mb_strimwidth(optional($topRestaurant->restaurant)->description, 0, 35, ' ..') }}
                                                    </h5>
                                                    <h6 class="text-sm"><span
                                                            style="color: #F36805;">{{ $topRestaurant->total_orders }}</span>
                                                        {{ __('dashboard.orders') }}</h6>
                                                </div>
                                            </li>
                                        @empty
                                        @endforelse
                                    </ul>
                                </div>
                            </div>
                        </div>
                    @endif
                    @if (isset($mostPopularItems))
                        <div class="col-12 xl:col-6">
                            <div class="db-card">
                                <div class="db-card-header">
                                    <div class="db-card-title">{{ __('dashboard.most_popular_items') }}</div>
                                </div>
                                <div class="db-card-body">
                                    <ul class="grid grid-cols-1 sm:grid-cols-2 gap-[18px]">
                                        @forelse ($mostPopularItems as $item)
                                            <li class="w-full flex rounded-xl border border-[#D9DBE9]">
                                                <img class="flex w-20 h-20 object-cover rounded-l-[11px]"
                                                    src="{{ $item->menuItem->image }}" alt="product">
                                                <div class="py-2 px-3 flex flex-col justify-between overflow-hidden">
                                                    <h4
                                                        class="text-sm overflow-hidden whitespace-nowrap text-ellipsis font-medium capitalize">
                                                        {{ $item->menuItem->name }}</h4>
                                                    <h5 class="text-xs font-medium capitalize text-[#008BBA]">
                                                        {{ mb_strimwidth($item->menuItem->categories->pluck('name')->join(', '), 0, 35, ' ..') }}
                                                    </h5>
                                                    <h6 class="text-sm font-bold">
                                                        {{ setting('currency_code') . ' ' . $item->menuItem->unit_price }}
                                                    </h6>
                                                </div>
                                            </li>
                                        @empty
                                        @endforelse
                                    </ul>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    @if (auth()->user()->myrole == App\Enums\UserRole::DELIVERYBOY)
        <div class="row mt-8">
            <div class="col-12 pb-0">
                <div class="flex items-center justify-between mb-4">
                    <h4 class="font-semibold text-[22px] leading-[34px] mb-3 capitalize">
                        {{ __('dashboard.active_orders') }}
                    </h4>
                </div>
            </div>
            <div class="col-12">

                <div id="activeOrders" class="">
                    <div class="">
                        <div class="row">
                            @forelse ($deliveryBoyActiveOrders as $key => $order)
                                <div class="col-12 md:col-6 lg:col-6 xl:col-4">
                                    <div
                                        class="w-full rounded-lg py-2 px-3 flex items-center gap-5 border border-[#EFF0F6] db-card">
                                        <svg width="32" height="32" viewBox="0 0 32 32" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M29.2936 23.9998V25.3332C29.2936 27.5332 29.2936 29.3332 25.2936 29.3332H6.62695C2.62695 29.3332 2.62695 27.5332 2.62695 25.3332V23.9998C2.62695 23.2665 3.22695 22.6665 3.96029 22.6665H27.9603C28.6936 22.6665 29.2936 23.2665 29.2936 23.9998Z"
                                                fill="#A0A3BD"></path>
                                            <path
                                                d="M19.2137 6.90685C19.2803 6.64018 19.3203 6.38685 19.3337 6.10685C19.3737 4.56018 18.427 3.20018 16.9337 2.80018C14.6937 2.18685 12.667 3.86685 12.667 6.00018C12.667 6.32018 12.707 6.61352 12.787 6.90685C7.97369 7.93352 4.36035 12.2135 4.36035 17.3335V19.3335C4.36035 20.0669 4.96035 20.6669 5.69368 20.6669H26.2937C27.027 20.6669 27.627 20.0669 27.627 19.3335V17.3335C27.627 12.2135 24.027 7.94685 19.2137 6.90685ZM20.0003 15.6669H12.0004C11.4537 15.6669 11.0004 15.2135 11.0004 14.6669C11.0004 14.1202 11.4537 13.6669 12.0004 13.6669H20.0003C20.547 13.6669 21.0003 14.1202 21.0003 14.6669C21.0003 15.2135 20.547 15.6669 20.0003 15.6669Z"
                                                fill="#A0A3BD"></path>
                                        </svg>
                                        <div class="w-full">
                                            <div class="flex items-center gap-3 mb-1">
                                                <p class="text-sm leading-6 font-client">{{ __('dashboard.order_id') }} :
                                                    <span class="text-heading">{{ '#' . $order->order_code }}</span>
                                                </p>
                                                <span class="mb-2" style="scale: 0.6;">{!! $order->statusName !!}</span>
                                            </div>
                                            <p class="text-xs font-light font-client mb-0.5">{{ $order->items_count }}
                                                {{ __('dashboard.items') }}</p>
                                            <p class="text-xs font-light font-client mb-1">
                                                {{ $order->created_at->format('H:m A, d M Y') }}</p>
                                            <div class="flex items-center justify-between">
                                                <p class="text-sm leading-6 font-client capitalize text-heading">Total:
                                                    <span class="font-medium">
                                                        {{ setting('currency_code') }}{{ $order->total }}</span>
                                                </p>
                                                <a href="{{ route('admin.orders.show', $order) }}"
                                                    class="text-[10px] leading-4 font-medium font-client flex items-center gap-1.5 text-primary">
                                                    {{ __('dashboard.see_order_details') }}
                                                    <svg width="6" height="10" viewBox="0 0 6 10" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M1.45508 8.96004L4.71508 5.70004C5.10008 5.31504 5.10008 4.68504 4.71508 4.30004L1.45508 1.04004"
                                                            stroke="#FF006B" stroke-width="1.5" stroke-miterlimit="10"
                                                            stroke-linecap="round" stroke-linejoin="round"></path>
                                                    </svg>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="col-12 md:col-12 lg:col-12 xl:col-12">
                                    <div class="flex items-center justify-center w-full h-full">
                                        <div class="flex items-center justify-center flex-col">
                                            <img style="width: 20%"
                                                src="{{ asset('backend/images/banner/cart-illustartion.png') }}"
                                                alt="">
                                            <div class="mt-4 font-medium text-black">
                                                {{ __('dashboard.no_delivery_order') }}</div>
                                        </div>
                                    </div>
                                </div>
                            @endforelse
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>
    @endif
@endsection


@push('js')
    <script defer src="{{ asset('backend/lib/apexcharts/apexcharts.min.js') }}"></script>
    <script defer src="{{ asset('js/dashboard/index.js') }}"></script>
    <script defer src="{{ asset('js/dashboard/area-chart.js') }}"></script>
    <script defer src="{{ asset('js/dashboard/radial-chart.js') }}"></script>
    <script defer src="{{ asset('js/dashboard/bar-chart.js') }}"></script>
@endpush
