<?php $__env->startSection('main-content'); ?>
    <!--======= LOGIN PART START ========-->
    <section class="auth">
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-8 col-lg-7">
                    <div class="auth-content">
                        <nav class="auth-navs">
                            <a class="nav-link active" href="<?php echo e(route('login')); ?>"> <?php echo e(__('login')); ?> </a>
                            <a class="nav-link" href="<?php echo e(route('register')); ?>"> <?php echo e(__('register')); ?></a>
                        </nav>
                        <div class="auth-tabs">
                            <div class="auth-header">
                                <h3><?php echo e(__('Welcome Back!')); ?></h3>
                                <p> <?php echo e(__('Please enter your login details below')); ?></p>
                            </div>
                            <form method="POST" class="login" action="<?php echo e(route('login')); ?>">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="type" value="frontend">

                                <div class="form-group">
                                    <label for="email" class="form-label"> <?php echo e(__('Email')); ?> </label>
                                    <input id="demoemail" type="email"
                                        class="form-control  <?php if($errors->has('email') || session('block')): ?> is-invalid <?php endif; ?>"
                                        name="email" value="<?php echo e(old('email')); ?>" autocomplete="email" autofocus
                                        placeholder="Email">
                                    <small
                                        class="form-alert red"><?php echo e(__("We'll never share your email with anyone else.")); ?></small>

                                    <?php if($errors->has('email')): ?>
                                        <span class="is-invalid" role="alert">
                                            <strong class="text-danger"><?php echo e($errors->first('email')); ?></strong>
                                        </span>
                                    <?php elseif(session('block')): ?>
                                        <span class="is-invalid" role="alert">
                                            <strong><?php echo e(session('block')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>

                                <div class="form-group">
                                    <label class="form-label" for="password"><?php echo e(__('Password:')); ?></label>
                                    <input placeholder="Password" id="demopassword" type="password"
                                        class="form-control <?php if($errors->has('password')): ?> is-invalid <?php endif; ?>"
                                        name="password" autocomplete="current-password">
                                    <?php if($errors->has('password')): ?>
                                        <span class="is-invalid" role="alert">
                                            <strong class="text-danger"><?php echo e($errors->first('password')); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>


                                <div class="d-flex justify-content-between">
                                    <div class="form-group form-check-group">
                                        <input type="checkbox" id="remember-me" name="check">
                                        <label for="remember-me"> <?php echo e(__('Remember me')); ?></label>
                                    </div>

                                    <div class="col-md-6 d-flex justify-content-end">
                                        <label for="forgot password">
                                            <a class="linkTxt" href="<?php echo e(route('password.request')); ?>"
                                                class="text-primary"><?php echo e(__('Forgot Password?')); ?></a>
                                        </label>
                                    </div>
                                </div>


                                <input type="submit" class="form-btn" value="Login">

                                <?php if(setting('facebook_key') || setting('google_key')): ?>
                                    <div class="auth-divide"><span><?php echo e(__('or login with ')); ?></span></div>
                                <?php endif; ?>

                                <nav class="auth-sync">
                                    <?php if(setting('google_key')): ?>
                                        <a href="<?php echo e(route('social-login', 'google')); ?>">
                                            <img src="<?php echo e(asset('frontend/images/social/google.png')); ?>" alt="social">
                                            <span><?php echo e(__('Google')); ?></span>
                                        </a>
                                    <?php endif; ?>

                                    <?php if(setting('facebook_key')): ?>
                                        <a href="<?php echo e(route('social-login', 'facebook')); ?>">
                                            <img src="<?php echo e(asset('frontend/images/social/facebook.png')); ?>" alt="social">
                                            <span><?php echo e(__('Facebook ')); ?></span>
                                        </a>
                                    <?php endif; ?>
                                </nav>
                            </form>
                        </div>

                        <?php if(env('DEMO_MODE')): ?>
                        <div class="card demo-login mx-auto text-center mt-2 border-0">

                            <div class="card-body border-0">
                                <h5 class="mb-2"><?php echo e(__('For Quick Demo Login Click Below...')); ?></h5>
                                <div class="buttons">
                                    <button id="demoadmin" class="btn btn-sm btn-primary"><?php echo e(__('Admin')); ?></button>
                                    <button id="democustomer" class="btn  btn-sm  btn-info "><?php echo e(__('Customer')); ?></button>
                                    <button id="demorestaurantowner"
                                        class="btn btn-success  btn-sm"><?php echo e(__('Restaurant Owner')); ?></button>
                                    <button id="demodeliveryboy" class="btn btn-warning  btn-sm "><?php echo e(__('Delivery Boy')); ?></button>
                                </div>
                            </div>
                        </div>
                       <?php endif; ?>

                    </div>
                </div>
            </div>
        </div>
        <img class="auth-banner" src="<?php echo e(asset('frontend/images/auth.jpg')); ?>" alt="auth">
    </section>
    <!--======== LOGIN PART END ========-->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('frontend/js/demo-login.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/mahbub/workspace/8.2/Foodbank/resources/views/auth/login.blade.php ENDPATH**/ ?>